using System;
using System.Collections.Generic;
using System.Globalization;

class Program
{
    struct Point
    {
        public double x, y;
        public int idx;
    }

    static void Main()
    {
        CultureInfo.CurrentCulture = CultureInfo.InvariantCulture;

        string[] first = Console.ReadLine().Split();
        int n = int.Parse(first[0]);
        double eps = double.Parse(first[1]);

        Point[] pts = new Point[n];
        for (int i = 0; i < n; i++)
        {
            string[] s = Console.ReadLine().Split();
            pts[i] = new Point
            {
                x = double.Parse(s[0]),
                y = double.Parse(s[1]),
                idx = i + 1 
            };
        }

        Dictionary<(int, int), Point> grid = new Dictionary<(int, int), Point>();

        for (int i = 0; i < n; i++)
        {
            int gx = (int)(pts[i].x / eps);
            int gy = (int)(pts[i].y / eps);
            var key = (gx, gy);

            if (!grid.ContainsKey(key))
                grid[key] = pts[i];
        }

        List<Point> Q = new List<Point>();
        foreach (var kv in grid)
            Q.Add(kv.Value);

        int maxAllowed = (int)(18.0 / (eps * eps));
        if (Q.Count > maxAllowed)
            Q.RemoveRange(maxAllowed, Q.Count - maxAllowed);

        int k = Q.Count;

        Console.WriteLine(k);
        for (int i = 0; i < k; i++)
        {
            if (i > 0) Console.Write(" ");
            Console.Write(Q[i].idx);
        }
        Console.WriteLine();

        for (int i = 1; i < k; i++)
        {
            Console.WriteLine(Q[i - 1].idx + " " + Q[i].idx);
        }
    }
}